@php

    function sureyiYazdir($sure) {

        $sure=ceil($sure/10)*10;

      if ($sure < 60) {
        echo $sure . ' dk';
      } else {
        $saat = floor($sure / 60);
        $dakika = $sure % 60;



        echo $saat . ' saat ';
        if($dakika>0){
        echo $dakika . ' dk';
        }
      }
    }

@endphp
@extends('master')
@section('icerik')
    <section>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <h2><i class="fa fa-check-circle text-success"></i> Transferiniz Planlandı</h2>
                    <p><b>{{ $alinmanoktasi }}</b> adresinden alınıp <b>{{ $birakilmanoktasi }}</b> adresine bırakılacağınız transferiniz ortalama <b>{{ round($distance) }} km</b> yol içermekte olup, trafiğe bağlı olmakla birlikte ortalama <b>{{ sureyiYazdir(round($distance*1.1)) }}</b> sürecektir. </p>

                    @if(count($arac)>1)
                    <div class="alert alert-info"><i class="fa fa-warning"></i> Lütfen aşağıdaki araç seçeneklerimizden birini seçerek rezervasyonunuza devam ediniz.
                        <a href="/" class="fw-bold"> Yeniden Hesapla</a> </div>
                    @else
                        <div class="alert alert-info"><i class="fa fa-warning"></i> Transfer fiyatımızı aşağıda bulabilirsiniz. Rezervasyon yap butonu ile transfer talwbinizi tamamlayabilirsiniz. </div>

                    @endif
                </div>

            </div>



<div id="osm">

    <div id="map" style="width: 100%; height: 400px;"></div>
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

    <script type="text/javascript">
        var startPoint = [{{ $origin }}]; // İlk noktanın enlem ve boylam değerleri
        var endPoint = [{{ $destination }}]; // İkinci noktanın enlem ve boylam değerleri

        var map = L.map('map'); // Harita oluştur

        var cartoDBLayer = L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png', {
            attribution: 'Map tiles by CartoDB, under CC BY 3.0. Data by OpenStreetMap, under ODbL'
        });

        cartoDBLayer.addTo(map);

        var startMarker = L.marker(startPoint).addTo(map); // Başlangıç noktasını işaretle
        var endMarker = L.marker(endPoint).addTo(map); // Bitiş noktasını işaretle

        // OSRM API'den yol bilgisini al
        var osrmUrl = 'https://router.project-osrm.org/route/v1/driving/' + startPoint[1] + ',' + startPoint[0] + ';' + endPoint[1] + ',' + endPoint[0] + '?overview=full&geometries=geojson';

        fetch(osrmUrl)
            .then(function(response) {
                return response.json();
            })
            .then(function(data) {
                var route = data.routes[0];
                var routeLayer = L.geoJSON(route.geometry).addTo(map); // Yolu çiz

                var bounds = routeLayer.getBounds(); // Yolun sınırlarını al
                map.fitBounds(bounds); // Sınırlara göre zoom yap
            });

            var mapElement = document.getElementById("map");

            mapElement.addEventListener("wheel", function(event) {
            event.preventDefault(); // Mouse scroll hareketini geçersiz yapmak için
        });
    </script>

    <style>
        .leaflet-control-attribution.leaflet-control {
            display: none!important;
        }
        #map {

            padding: 20px;
            background: #ffffff;
            border: solid 1px #dddddd;
            box-shadow: 3px 3px 9px rgba(164,164,186,0.2);
            border-radius: 6px;
            -moz-border-radius: 6px;
            -webkit-border-radius: 6px;
        }

        #map {
            pointer-events: none;

        }

        #map::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5); /* Karartma rengi */
        }

        #map div.overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

    </style>

</div>
            <div style="margin: 15px!important;">

                @if(count($arac)>1)
            <h3><i class="fa fa-car text-success"></i> Lütfen Araç Seçiniz</h3> @endif
            </div>
@foreach($arac as $item)
            <div class="col-lg-12" style="background-size: 100%; background-repeat: no-repeat;">
                <div class="de-item-list mb30" style="background-size: 100%; background-repeat: no-repeat;">
                    <div class="d-img" style="background-size: 100%; background-repeat: no-repeat;">
                        <img src="{{ $item->img }}" class="img-fluid" alt="">
                    </div>
                    <div class="d-info" style="background-size: 100%; background-repeat: no-repeat;">
                        <div class="d-text" style="background-size: 100%; background-repeat: no-repeat;">
                            <h4>{{ $item->isim }}</h4>
                            <div class="d-atr-group" style="background-size: 100%; background-repeat: no-repeat;">
                                <ul class="d-atr">
                                    <li><i class="icofont-users"></i> <span>Yolcu:</span>{{ $item->yolcu }}</li>
                                    <li><i class="fa fa-shopping-bag"></i> <span>Bagaj:</span>{{ $item->bagaj }}</li>
                                    <li><i class="fa fa-car"></i> <span>Tip:</span>{{ $item->tip }}</li>
                                    <li><i class="icofont icofont-badge"></i> <span>Kapı:</span>{{ $item->kapi }}</li>
                                    <li><i class="icofont-crown"></i><span>VIP:</span>{{ $item->vip }}</li>
                                    <li><i class="icofont-calendar"></i> <span>Model:</span>{{ $item->model }}</li>
                                    <li><i class="icofont-atom"></i> <span>Yakıt:</span>{{ $item->yakit }}</li>
                                    <li><i class="icofont-ship-wheel"></i> <span>Çekiş:</span>{{ $item->cekis }}</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="d-price" style="background-size: 100%; background-repeat: no-repeat;">
                        Tek Yön Transfer Fiyatımız <span>{{ number_format((($item->acilis)+($distance*$item->km)),2) }}  {{ $ayar['pb'] }}</span>
                        Çift Yön Transfer Fiyatımız <span>{{ number_format($item->acilis+(($item->acilis)+($distance*$item->km*1.75)),2) }}  {{ $ayar['pb'] }}</span>
                        <a class="btn-main" href="/rezervasyon?arac={{ $item->id }}&sorgu={{ $transferid }}"> <i class="fa fa-caret-right"></i> Rezervasyon Yap</a>
                    </div>
                    <div class="clearfix" style="background-size: 100%; background-repeat: no-repeat;"></div>
                </div>
            </div>
            @endforeach
        </div>


    </section>


@endsection
