@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Ayarlar</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Ayarlar</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->



    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Ayarları Güncelle</div>
                    <div class="card-body">

                        <form action="ayarlar" class="arala" method="post" enctype="multipart/form-data">
                            @csrf

                            <div class="row" style="display: flex">

                                @foreach($ayar as $item)
                                    <div class="col-lg-4">

                                        @if($item->deger==0 || $item->deger==1)

                                            <div>
                                                <div>{{ $item->gorunen }}</div>
                                                <div><select name="{{ $item->id }}" id="" class="form-select">
                                                        <option value="1"  @if($item->deger=="1") selected @endif>Açık - Görünür</option>
                                                        <option value="0" @if($item->deger<>"1") selected @endif>Kapalı - Görünmez</option>
                                                    </select></div>
                                            </div>

                                        @else
                                            <span class="fw-semibold"> {{$item->gorunen}}</span>
                                            @if(strlen($item->deger)>70)
                                                <textarea cols="10" rows="3"
                                                          style="height: auto" class="form-control"
                                                          name="{{ $item->id }}">{!! $item->deger !!}</textarea>
                                            @else
                                                <input type="text" name="{{ $item->id }}" id=""
                                                       value="{{ $item->deger }}" class="form-control">

                                            @endif
                                        @endif
                                    </div>
                                @endforeach
                            </div>

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Güncelle</button>

                        </form>

                    </div>
                </div>
            </div>


        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arala span {
            font-size: 13px;
            color: darkgray
        }
    </style>

@endsection
@section('title','Ayarlar ')
