@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Ek Hizmetler</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Ek Hizmetler</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Ek Hizmet Ekle</div>
                    <div class="card-body">

                        <form action="hizmetekle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf
                            Tur Kategorisi

                            <input type="text" name="hizmet" class="form-control" placeholder="Hizmet">
                            <input type="text" name="ucret" class="form-control" placeholder="Ücret">

                            <button class="btn btn-success"><i class="bx bxs-save"></i>  Ekle</button>

                        </form>

                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Ek Hizmetler</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Hizmet</td>
                                <td>Ücret</td>

                                <td width="1">Sil</td>
                            </tr>
                            @foreach($ekhizmet as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>{{$item->hizmet}}</td>
                                    <td>{{$item->ucret}}</td>
                                    <td nowrap=""><a onclick="silmi('/admin/ekhizmetsil?id={{ $item->id }}')" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i> Sil</a></td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>

@endsection
@section('title','Ek Hizmetler')
