@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Kiralık Araçlar</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Kiralık Araçları</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Araç Ekle</div>
                    <div class="card-body">


                        <form action="kiralikaracekle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf
                            Araç Adı
                            <input required required type="text" class="form-control" name="isim">

                            Model Yılı
                            <input required type="number" class="form-control" name="model">
                            Yakıt
                            <select name="yakit" class="form-select" id="">
                                @foreach($yakit as $item)
                                    <option value="{{$item}}">{{ $item }}</option>
                                @endforeach
                            </select> Tip
                            <select name="tip" class="form-select" id="">
                                @foreach($tip as $item)
                                    <option value="{{$item}}">{{ $item }}</option>
                                @endforeach
                            </select>
                            Yolcu Sayısı
                            <input required type="number" class="form-control" name="yolcu">
                            Bagaj Sayısı
                            <input required type="number" class="form-control" name="bagaj">
                            Kapı Sayısı
                            <input required type="number" class="form-control" name="kapi">

                            Araç Fotoğrafı
                            <input required type="file" accept="image/*" name="img" class="form-control">

                            Ücret 1 Günlük
                            <input required type="text" name="ucret1"  class="form-control">
                            Ücret 30+ Gün
                            <input required type="text" name="ucret30"  class="form-control">
                            Ücret 180+ Gün
                            <input required type="text" name="ucret180"  class="form-control">
Ücret 360+ Gün
                            <input required type="text" name="ucret360"  class="form-control">


                            <button class="btn btn-success"><i class="bx bxs-save"></i> Aracı Ekle</button>

                        </form>


                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Araçlar</div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <tr class="fw-bold">
                                <td>#</td>
                                <td>Foto</td>
                                <td>İsim</td>
                                <td>Model</td>
                                <td>Yakıt</td>
                                <td>Ücret</td>
                                <td>Kiralanabilir</td>
                                <td>Düzenle</td>
                                <td>Sil</td>
                            </tr>

                            @foreach($araclar as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>
                                    <td><img src="/{{ trim($item->img,"/") }}"  class="arabafoto" alt=""></td>
                                    <td>{{ $item->isim }}</td>
                                    <td>{{ $item->model }}</td>
                                    <td>{{ $item->yakit }}</td>
                                    <td style="min-width: 300px;">

                                        <div class="aracfiyat">
                                            <div>1 Gün</div>
                                            <div>{{ $item->ucret1 }} </div>
                                        </div>
                                        <div class="aracfiyat">
                                            <div >30 Gün</div>
                                            <div >{{ $item->ucret30 }} </div>
                                        </div>
                                        <div class="aracfiyat">
                                            <div >180 Gün</div>
                                            <div >{{ $item->ucret180 }} </div>
                                        </div>
                                        <div class="aracfiyat">
                                            <div >360 Gün</div>
                                            <div >{{ $item->ucret360 }} </div>
                                        </div>

                                    </td>
                                    <td>@if($item->aktif==1) <div class="btn btn-sm btn-success">Evet</div>@else <div class="btn-danger btn-sm btn">Hayır</div> @endif</td>
                                    <td><a href="karacduzenle?id={{ $item->id }}" class="btn btn-sm btn-primary"><i class="bx bx-pen"></i> Düzenle</a></td>
                                    <td><a onclick="silmi('/admin/karacsil?id={{ $item->id }}')" class="btn btn-sm btn-danger"><i class="bx bx-trash"></i> Sil</a></td>
                                </tr>

                            @endforeach

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px; max-width: 50px; max-height: 50px;}
        .aracfiyat div { width:45%;float: left; min-width: 100px;  }
        .aracfiyat div:nth-child(1) {
            text-align: right;
            margin-right: 10px;
        }

        .aracfiyat div:nth-child(2) {
            text-align: left;
        }

        .input-group {text-align: left!important;}
    </style>

@endsection
@section('title','Transfer Araçları')
