@extends('panel.index')
@section('icerik')

    <div class="pagetitle">
        <h1>Transfer Aracı Düzenle - {{ $arac->isim."-".$arac->model }}</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Transfer Aracı Düzenle</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Araç Ekle</div>
                    <div class="card-body">

                        <form action="taracduzenle" class="arala" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{ $request->id }}" id="">
                            Araç Adı
                            <input required required type="text" class="form-control" name="isim" value="{{ $arac->isim }}"> Araç Tipi
                            <select name="tip" class="form-select" id="">
                                <option value="{{ $arac->tip }}" selected hidden>{{ $arac->tip }}</option>
                                @foreach($aracTipleri as $item)
                                    <option value="{{ $item }}">{{ $item }}</option>
                                @endforeach

                            </select>
                            Model Yılı
                            <input required type="number" class="form-control" name="model" value="{{ $arac->model }}">
                            Yakıt
                            <select name="yakit" class="form-select" id="">
                                <option value="{{ $arac->yakit}}" selected hidden="">{{ $arac->yakit   }}</option>
                                @foreach($yakit as $item)
                                    <option value="{{$item}}">{{ $item }}</option>
                                @endforeach
                            </select>Çekiş
                            <select name="cekis" class="form-select" id="">
                                <option value="{{ $arac->cekis }}" selected hidden>{{ $arac->cekis  }}</option>
                                @foreach($cekis as $item)
                                    <option value="{{$item}}">{{ $item }}</option>
                                @endforeach
                            </select>

                            Yolcu Sayısı
                            <input required type="number" class="form-control" name="yolcu" value="{{ $arac->yolcu  }}">
                            Bagaj Sayısı
                            <input required type="number" class="form-control" name="bagaj" value="{{ $arac->bagaj }}">
                            Kapı Sayısı
                            <input required type="number" class="form-control" name="kapi" value="{{ $arac->bagaj }}">

                            Araç Fotoğrafı <span>*yenisi yüklenmezse eskisi kalır</span>
                            <input  type="file" name="img" class="form-control" accept="image/*">

                            Açılış Ücreti
                            <input required type="text" name="acilis" value="{{$arac->acilis}}" class="form-control">
                            KM Ücreti
                            <input required type="text" name="km" value="{{ $arac->km }}" class="form-control">

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Aracı Güncelle</button>

                        </form>

                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header"><i class="bx bx-camera"></i> Araç Fotoğrafı</div>
                    <div class="card-body">
                        <img src="/{{ $arac->img }}" style="width: 100%;" alt="">
                    </div>
                </div>
            </div>

        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }
        .arala span { font-size: 13px; color: darkgray}
    </style>

@endsection
@section('title','Transfer Aracı Düzenle '. $arac->isim)
