@extends('panel.index')
@section('icerik')
    <style>
        .mw200 { max-width: 200px;}
    </style>
    <div class="pagetitle">
        <h1>Transfer Talepleri</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Transfer Talepleri</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="col-12">
            <div class="card">

                <div class="filter">
                    <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-filter"></i> Filtrele</a>
                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                        <li class="dropdown-header text-start">
                            <h6>Durum</h6>
                        </li>

                        <li><a class="dropdown-item" href="transfer-talepleri">Hepsi</a></li>
                        @foreach($durums as $item)
                        <li><a class="dropdown-item @if($item->durum==$request->durum) fw-bold @endif" href="transfer-talepleri?durum={{ $item->durum }}">{{ $item->durum }}</a></li>
                        @endforeach
                    </ul>
                </div>

                <div class="card-body">
                    <h5 class="card-title">Talepler <span></span></h5>


                    <table class="table table-hover">
                        <tr class="fw-bold">
                            <td>Id</td>
                            <td>Yön</td>
                            <td>Müşteri</td>
                            <td>Alınma</td>
                            <td >Bırakılma</td>

                            <td>KM</td>
                            <td>İş Emri</td>
                            <td>Durum</td>

                            <td>Sil</td>
                        </tr>

                        @foreach($transfer as $item)
                            <tr>
                                <td>{{ $item->talepid }}</td>
                                <td>{{ $item->yon }}</td>
                                <td>{{ ucwords($item->name) }} <br> {{ $item->telefon }}</td>
                                <td class="mw200">{{ $item->alinmanoktasi }} <br> <i class="bx bx-calendar"></i> {{ \Carbon\Carbon::createFromDate($item->alinmatarihi)->format('d/m/Y H:i') }}</td>
                                <td class="mw200" >{{ $item->birakilmanoktasi }} <br> <i class="bx bx-calendar"></i> {{ \Carbon\Carbon::createFromDate($item->birakilmatarihi)->format('d/m/Y H:i') }}</td>
                             <td>{{$item->distance}}Km</td>
                                <td><a target="_blank" href="is-emri?id={{ $item->talepid }}" class="btn btn-outline-info btn-sm"><i class="bi bi-map"></i> İş Emri Yazdır</a></td>
                                <td>{{ $item->durum }}</td>


                                <td><div onclick="silmi('/admin/ttalepsil?id={{ $item->talepid }}')" class="btn btn-sm btn-danger"><i class="bi-trash bi"></i> İptal Et</div></td>


                            </tr>
                        @endforeach
                    </table>


                </div>

            </div>
        </div>
    </section>

@endsection
@section('title','Transfer Talepleri')
