﻿<!DOCTYPE html>
<html lang="tr">

<head>
    <title>{{ $ayar['title'] }}</title>
    <base href="/">
    <link rel="icon" href="images/icon.png" type="image/gif" sizes="16x16">
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Rentaly - Multipurpose Vehicle Car Rental Website Template" name="description">
    <meta content="" name="keywords">
    <meta content="" name="author">
    <!-- CSS Files
    ================================================== -->
    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" id="bootstrap">
    <link href="css/mdb.min.css" rel="stylesheet" type="text/css" id="mdb">
    <link href="css/plugins.css" rel="stylesheet" type="text/css">
    <link href="css/style.css" rel="stylesheet" type="text/css">
    <link href="css/coloring.css" rel="stylesheet" type="text/css">
    <!-- color scheme -->
    <link id="colors" href="css/colors/scheme-01.css" rel="stylesheet" type="text/css">
</head>

<body onload="initialize()">
    <div id="wrapper">

        <!-- page preloader begin -->
        <div id="de-preloader">
            asdf
        </div>
        <!-- page preloader close -->

        <!-- header begin -->
        <header class="transparent scroll-light has-topbar">
            <div id="topbar" class="topbar-dark text-light">
                <div class="container">
                    <div class="topbar-left xs-hide">
                        <div class="topbar-widget">
                            <div class="topbar-widget"><a href="#"><i class="fa fa-phone"></i>{{ $ayar['telefon'] }}</a></div>
                            <div class="topbar-widget"><a href="#"><i class="fa fa-envelope"></i>{{ $ayar['mail'] }}</a></div>
                            <div class="topbar-widget"><a href="#"><i class="fa fa-clock-o"></i>{{ $ayar['mesai'] }}</a></div>
                        </div>
                    </div>

                    <div class="topbar-right">
                        <div class="social-icons">
                           @isset($ayar['facebook'])
                            <a href="#"><i class="fa fa-facebook fa-lg"></i></a>
                            @endisset
                            <a href="#"><i class="fa fa-twitter fa-lg"></i></a>
                            <a href="#"><i class="fa fa-youtube fa-lg"></i></a>
                            <a href="#"><i class="fa fa-pinterest fa-lg"></i></a>
                            <a href="#"><i class="fa fa-instagram fa-lg"></i></a>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="de-flex sm-pt10">
                            <div class="de-flex-col">
                                <div class="de-flex-col">
                                    <!-- logo begin -->
                                    <div id="logo">
                                        <a href="index.html">
                                            <img class="logo-1" src="images/logo-light.png" alt="">
                                            <img class="logo-2" src="images/logo.png" alt="">
                                        </a>
                                    </div>
                                    <!-- logo close -->
                                </div>
                            </div>
                            <div class="de-flex-col header-col-mid">
                                <ul id="mainmenu">
                                    <li><a class="menu-item" href="/">Ana Sayfa</a>

                                    </li>
                                    <li><a class="menu-item" href="/araclar">Transfer</a>
                                        <ul>
                                            @foreach($transkat as $item)
                                            <li><a class="menu-item" href="/araclar/{{ $item->kategori_slug }}">{{ $item->kategori }}</a></li>
                                            @endforeach
                                        </ul>
                                    </li><li><a class="menu-item" href="/araclar">Rent a Car</a>
                                        <ul>
                                            @foreach($transkat as $item)
                                            <li><a class="menu-item" href="/araclar/{{ $item->kategori_slug }}">{{ $item->kategori }}</a></li>
                                            @endforeach
                                        </ul>
                                    </li>
                                    <li><a class="menu-item" href="/rezervasyon">Rezervasyon</a></li>
                                    <li><a class="menu-item" href="/hesabim">Hesabım</a>

                                        @if(auth()->check())
                                        <ul>
                                            <li><a class="menu-item" href="account-dashboard.html">Dashboard</a></li>
                                            <li><a class="menu-item" href="account-profile.html">My Profile</a></li>
                                            <li><a class="menu-item" href="account-booking.html">My Orders</a></li>
                                            <li><a class="menu-item" href="account-favorite.html">My Favorite Cars</a></li>
                                        </ul>
                                        @else
                                        <ul>
                                            <li><a href="/uye-ol" class="menu-item">Üye Ol</a></li>
                                            <li><a href="/giris-yap" class="menu-item">Giriş Yap</a></li>
                                        </ul>
                                            @endif
                                    </li>
                                    <li><a class="menu-item" href="/blog">Blog</a>

                                    </li>

                                </ul>
                            </div>
                            <div class="de-flex-col">
                                <div class="menu_side_area">
                                    @if(auth()->check())
                                        <a href="/panel" class="btn-main">Panelim</a>
                                    @else
                                    <a href="/login" class="btn-main">Giriş Yap</a>
                                    @endif
                                    <span id="menu-btn"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- header close -->
        <!-- content begin -->
        <div class="no-bottom no-top" id="content">
            <div id="top"></div>
            <section id="section-hero" aria-label="section" class="jarallax no-top no-bottom" data-video-src="{{ $ayar['bgvideo'] }}">
                <div class="overlay-bg no-top no-bottom">
                    <div class="v-center">
                        <div class="container position-relative z1000">
                            <div class="spacer-double d-lg-none d-sm-block"></div>
                            <div class="spacer-double d-lg-none d-sm-block"></div>
                            <div class="spacer-double d-lg-none d-sm-block"></div>
                            <div class="row align-items-center">
                                <div class="col-lg-6 text-light">
                                    <h4><span class="id-color">{{ @$ayar['h4slogan'] }}</span></h4>
                                    <div class="spacer-10"></div>
                                    <h1 class="mb-2">{{ @$ayar['h1slogan'] }}</h1>
                                    <div class="spacer-10"></div>
                                    <p class="lead">{!! @$ayar['mainp'] !!}</p>
                                </div>

                                <div class="col-lg-6">
                                    <div class="spacer-single sm-hide"></div>
                                    <div class="p-4 rounded-3 shadow-soft text-light" data-bgcolor="rgba(0, 0, 0, .6)">


                                        <form name="contactForm" id='contact_form' method="post">
                                            <h5>{{ $ayar['neturarac'] }}</h5>

                                            <div class="de_form de_radio row g-3">
                                                <div class="radio-img col-lg-3 col-sm-3 col-6">
                                                    <input id="radio-1a" name="Car_Type" type="radio" value="Residential" checked="checked">
                                                    <label for="radio-1a"><img src="images/select-form/car.png" alt="">Otomobil</label>
                                                </div>

                                                <div class="radio-img col-lg-3 col-sm-3 col-6">
                                                    <input id="radio-1b" name="Car_Type" type="radio" value="Office">
                                                    <label for="radio-1b"><img src="images/select-form/minibus.png" alt="">Minibüs</label>
                                                </div>

                                                <div class="radio-img col-lg-3 col-sm-3 col-6">
                                                    <input id="radio-1c" name="Car_Type" type="radio" value="Commercial">
                                                    <label for="radio-1c"><img src="images/select-form/minibus.png" alt="">VIP Minibüs</label>
                                                </div>

                                                <div class="radio-img col-lg-3 col-sm-3 col-6">
                                                    <input id="radio-1d" name="Car_Type" type="radio" value="Retail">
                                                    <label for="radio-1d"><img src="images/select-form/sportscar.png" alt="">VIP Oto</label>
                                                </div>
                                            </div>

                                            <div class="spacer-20"></div>

                                            <div class="row">
                                                <div class="col-lg-6 mb20">
                                                    <h5>{{ $ayar['alinma'] }}</h5>
                                                    <input type="text" name="origin" required onfocus="geolocate()" placeholder="tam adres yazabilirsiniz" id="autocomplete" autocomplete="off" class="form-control">

                                                    <div class="jls-address-preview jls-address-preview--hidden">
                                                        <div class="jls-address-preview__header">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 mb20">
                                                    <h5>{{ $ayar['birakilma'] }}</h5>
                                                    <input type="text" required name="destination" onfocus="geolocate()" placeholder="tam adres yazabilirsiniz" id="autocomplete2" autocomplete="off" class="form-control">

                                                    <div class="jls-address-preview jls-address-preview--hidden">
                                                        <div class="jls-address-preview__header">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 mb20">
                                                    <h5>{{ $ayar['alinmatarih'] }}</h5>
                                                    <div class="date-time-field">
                                                        <input type="text" class="date-picker" name="alinmatarihi" value="{{ date('Y-m-d') }}">
                                                        <select name="Pick Up Time" id="pickup-time" class="saatsec">
                                                            <option selected="" disabled="" value="Select time">Saat</option>
                                                            <option value="00:00">00:00</option>
                                                            <option value="00:30">00:30</option>
                                                            <option value="01:00">01:00</option>
                                                            <option value="01:30">01:30</option>
                                                            <option value="02:00">02:00</option>
                                                            <option value="02:30">02:30</option>
                                                            <option value="03:00">03:00</option>
                                                            <option value="03:30">03:30</option>
                                                            <option value="04:00">04:00</option>
                                                            <option value="04:30">04:30</option>
                                                            <option value="05:00">05:00</option>
                                                            <option value="05:30">05:30</option>
                                                            <option value="06:00">06:00</option>
                                                            <option value="06:30">06:30</option>
                                                            <option value="07:00">07:00</option>
                                                            <option value="07:30">07:30</option>
                                                            <option value="08:00">08:00</option>
                                                            <option value="08:30">08:30</option>
                                                            <option value="09:00">09:00</option>
                                                            <option value="09:30">09:30</option>
                                                            <option value="10:00">10:00</option>
                                                            <option value="10:30">10:30</option>
                                                            <option value="11:00">11:00</option>
                                                            <option value="11:30">11:30</option>
                                                            <option value="12:00">12:00</option>
                                                            <option value="12:30">12:30</option>
                                                            <option value="13:00">13:00</option>
                                                            <option value="13:30">13:30</option>
                                                            <option value="14:00">14:00</option>
                                                            <option value="14:30">14:30</option>
                                                            <option value="15:00">15:00</option>
                                                            <option value="15:30">15:30</option>
                                                            <option value="16:00">16:00</option>
                                                            <option value="16:30">16:30</option>
                                                            <option value="17:00">17:00</option>
                                                            <option value="17:30">17:30</option>
                                                            <option value="18:00">18:00</option>
                                                            <option value="18:30">18:30</option>
                                                            <option value="19:00">19:00</option>
                                                            <option value="19:30">19:30</option>
                                                            <option value="20:00">20:00</option>
                                                            <option value="20:30">20:30</option>
                                                            <option value="21:00">21:00</option>
                                                            <option value="21:30">21:30</option>
                                                            <option value="22:00">22:00</option>
                                                            <option value="22:30">22:30</option>
                                                            <option value="23:00">23:00</option>
                                                            <option value="23:30">23:30</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-lg-6 mb20">
                                                    <h5>{{ $ayar['birakmatarih'] }}</h5>
                                                    <div class="date-time-field">
                                                        <input type="text" class="date-picker" name="birakilmatarihi" value="">
                                                        <select name="Collection Time" id="collection-time" class="saatsec">
                                                            <option selected="" disabled="" value="Select time">Saat</option>
                                                            <option value="00:00">00:00</option>
                                                            <option value="00:30">00:30</option>
                                                            <option value="01:00">01:00</option>
                                                            <option value="01:30">01:30</option>
                                                            <option value="02:00">02:00</option>
                                                            <option value="02:30">02:30</option>
                                                            <option value="03:00">03:00</option>
                                                            <option value="03:30">03:30</option>
                                                            <option value="04:00">04:00</option>
                                                            <option value="04:30">04:30</option>
                                                            <option value="05:00">05:00</option>
                                                            <option value="05:30">05:30</option>
                                                            <option value="06:00">06:00</option>
                                                            <option value="06:30">06:30</option>
                                                            <option value="07:00">07:00</option>
                                                            <option value="07:30">07:30</option>
                                                            <option value="08:00">08:00</option>
                                                            <option value="08:30">08:30</option>
                                                            <option value="09:00">09:00</option>
                                                            <option value="09:30">09:30</option>
                                                            <option value="10:00">10:00</option>
                                                            <option value="10:30">10:30</option>
                                                            <option value="11:00">11:00</option>
                                                            <option value="11:30">11:30</option>
                                                            <option value="12:00">12:00</option>
                                                            <option value="12:30">12:30</option>
                                                            <option value="13:00">13:00</option>
                                                            <option value="13:30">13:30</option>
                                                            <option value="14:00">14:00</option>
                                                            <option value="14:30">14:30</option>
                                                            <option value="15:00">15:00</option>
                                                            <option value="15:30">15:30</option>
                                                            <option value="16:00">16:00</option>
                                                            <option value="16:30">16:30</option>
                                                            <option value="17:00">17:00</option>
                                                            <option value="17:30">17:30</option>
                                                            <option value="18:00">18:00</option>
                                                            <option value="18:30">18:30</option>
                                                            <option value="19:00">19:00</option>
                                                            <option value="19:30">19:30</option>
                                                            <option value="20:00">20:00</option>
                                                            <option value="20:30">20:30</option>
                                                            <option value="21:00">21:00</option>
                                                            <option value="21:30">21:30</option>
                                                            <option value="22:00">22:00</option>
                                                            <option value="22:30">22:30</option>
                                                            <option value="23:00">23:00</option>
                                                            <option value="23:30">23:30</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <input type='submit' value='{{ $ayar['aracbul'] }}' class="btn-main pull-right">

                                            <div class="clearfix"></div>

                                        </form>
                                    </div>
                                </div>

                            </div>
                            <div class="spacer-double d-lg-none d-sm-block"></div>
                            <div class="spacer-double d-lg-none d-sm-block"></div>
                        </div>

                    </div>
                </div>
            </section>



            <section id="section-cars">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h2>{{ $ayar['araclarimiz'] }}</h2>
                            <p>{{ $ayar['araclarimizp'] }}</p>
                            <div class="spacer-20"></div>
                        </div>

                        <div class="clearfix"></div>

                        <div id="items-carousel" class="owl-carousel wow fadeIn">

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/jeep-renegade.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>Jeep Renegade</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>74</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">SUV</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$265</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/bmw-m5.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>BMW M2</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>36</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">Sedan</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$244</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/ferrari-enzo.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>Ferarri Enzo</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>85</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">Exotic Car</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$167</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/ford-raptor.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>Ford Raptor</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>59</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">Pickup Truck</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$147</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/mini-cooper.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>Mini Cooper</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>19</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">Hatchback</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$238</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="de-item mb30">
                                    <div class="d-img">
                                        <img src="images/cars/vw-polo.jpg" class="img-fluid" alt="">
                                    </div>
                                    <div class="d-info">
                                        <div class="d-text">
                                            <h4>VW Polo</h4>
                                            <div class="d-item_like">
                                                <i class="fa fa-heart"></i><span>79</span>
                                            </div>
                                            <div class="d-atr-group">
                                                <span class="d-atr"><img src="images/icons/1.svg" alt="">5</span>
                                                <span class="d-atr"><img src="images/icons/2.svg" alt="">2</span>
                                                <span class="d-atr"><img src="images/icons/3.svg" alt="">4</span>
                                                <span class="d-atr"><img src="images/icons/4.svg" alt="">Hatchback</span>
                                            </div>
                                            <div class="d-price">
                                                Daily rate from <span>$106</span>
                                                <a class="btn-main" href="car-single.html">Rent Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </section>

            <section class="text-light jarallax">
                <img src="images/background/2.jpg" class="jarallax-img" alt="">
                <div class="container">
                    <div class="row g-5">
                        <div class="col-lg-6 wow fadeInRight">
                            <h2>We offer customers a wide range of <span class="id-color">commercial cars</span> and <span class="id-color">luxury cars</span> for any occasion.</h2>
                        </div>
                        <div class="col-lg-6 wow fadeInLeft">
                            Lorem ipsum non aliquip esse do eu ad amet laboris do labore reprehenderit mollit exercitation cillum irure fugiat magna laboris aliquip adipisicing consectetur officia dolor minim ea enim amet in ut non non excepteur anim magna dolor nostrud commodo qui irure deserunt adipisicing nisi ex nostrud sunt officia in aliquip velit anim id aliqua qui do sed non ad qui sed in eu in aliqua sunt pariatur occaecat in ullamco deserunt dolor consectetur laborum non duis occaecat nulla ut sed qui sunt id ex sint sed eu excepteur minim nulla minim excepteur exercitation.
                        </div>
                    </div>
                    <div class="spacer-double"></div>
                    <div class="row text-center">
                        <div class="col-md-3 col-sm-6 mb-sm-30">
                            <div class="de_count transparent text-light wow fadeInUp">
                                <h3 class="timer" data-to="15425" data-speed="3000">0</h3>
                                Hours of Work
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-sm-30">
                            <div class="de_count transparent text-light wow fadeInUp">
                                <h3 class="timer" data-to="8745" data-speed="3000">0</h3>
                                Clients Supported
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-sm-30">
                            <div class="de_count transparent text-light wow fadeInUp">
                                <h3 class="timer" data-to="235" data-speed="3000">0</h3>
                                Awards Winning
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 mb-sm-30">
                            <div class="de_count transparent text-light wow fadeInUp">
                                <h3 class="timer" data-to="15" data-speed="3000">0</h3>
                                Years Experience
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section aria-label="section">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h2>Our Features</h2>
                            <p>Dolor esse sint officia est voluptate et qui deserunt et est eiusmod cillum mollit sunt nulla cillum sit ut culpa ullamco.</p>
                            <div class="spacer-20"></div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-lg-3">
                            <div class="box-icon s2 p-small mb20 wow fadeInRight" data-wow-delay=".5s">
                                <i class="fa bg-color fa-trophy"></i>
                                <div class="d-inner">
                                    <h4>First class services</h4>
                                    Est dolore ut laboris eu enim eu veniam nostrud esse laborum duis consequat nostrud id
                                </div>
                            </div>
                            <div class="box-icon s2 p-small mb20 wow fadeInL fadeInRight" data-wow-delay=".75s">
                                <i class="fa bg-color fa-road"></i>
                                <div class="d-inner">
                                    <h4>24/7 road assistance</h4>
                                     Est dolore ut laboris eu enim eu veniam nostrud esse laborum duis consequat nostrud id
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <img src="images/misc/car-2.png" alt="" class="img-fluid wow fadeInUp">
                        </div>

                        <div class="col-lg-3">
                            <div class="box-icon s2 d-invert p-small mb20 wow fadeInL fadeInLeft" data-wow-delay="1s">
                                <i class="fa bg-color fa-tag"></i>
                                <div class="d-inner">
                                    <h4>Quality at Minimum Expense</h4>
                                     Est dolore ut laboris eu enim eu veniam nostrud esse laborum duis consequat nostrud id
                                </div>
                            </div>
                            <div class="box-icon s2 d-invert p-small mb20 wow fadeInL fadeInLeft" data-wow-delay="1.25s">
                                <i class="fa bg-color fa-map-pin"></i>
                                <div class="d-inner">
                                    <h4>Free Pick-Up & Drop-Off</h4>
                                     Est dolore ut laboris eu enim eu veniam nostrud esse laborum duis consequat nostrud id
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-img-with-tab" class="bg-dark text-light">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-5 offset-lg-7">

                            <h2>Only Quality For Clients</h2>
                            <div class="spacer-20"></div>

                            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                              <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">Luxury</button>
                              </li>
                              <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">Comfort</button>
                              </li>
                              <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill" data-bs-target="#pills-contact" type="button" role="tab" aria-controls="pills-contact" aria-selected="false">Prestige</button>
                              </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                              <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab"><p>Consequat occaecat ullamco amet non eiusmod nostrud dolore irure incididunt est duis anim sunt officia. Fugiat velit proident aliquip nisi incididunt nostrud exercitation proident est nisi. Irure magna elit commodo anim ex veniam culpa eiusmod id nostrud sit cupidatat in veniam ad. Eiusmod consequat eu adipisicing minim anim aliquip cupidatat culpa excepteur quis. Occaecat sit eu exercitation irure Lorem incididunt nostrud.</p></div>
                              <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab"><p>Ad pariatur nostrud pariatur exercitation ipsum ipsum culpa mollit commodo mollit ex. Aute sunt incididunt amet commodo est sint nisi deserunt pariatur do. Aliquip ex eiusmod voluptate exercitation cillum id incididunt elit sunt. Qui minim sit magna Lorem id et dolore velit Lorem amet exercitation duis deserunt. Anim id labore elit adipisicing ut in id occaecat pariatur ut ullamco ea tempor duis.</p></div>
                              <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab"><p>Est quis nulla laborum officia ad nisi ex nostrud culpa Lorem excepteur aliquip dolor aliqua irure ex. Nulla ut duis ipsum nisi elit fugiat commodo sunt reprehenderit laborum veniam eu veniam. Eiusmod minim exercitation fugiat irure ex labore incididunt do fugiat commodo aliquip sit id deserunt reprehenderit aliquip nostrud. Amet ex cupidatat excepteur aute veniam incididunt mollit cupidatat esse irure officia elit do ipsum ullamco Lorem.</p></div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="image-container col-md-6 pull-right" data-bgimage="url(images/misc/e2.jpg) center"></div>
            </section>

            <section id="section-news">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 offset-lg-3 text-center">
                            <h2>Latest News</h2>
                            <p>Sit labore et officia eiusmod tempor officia eiusmod dolor exercitation nulla dolore ut id velit et ut anim.</p>
                            <div class="spacer-20"></div>
                        </div>

                        <div class="col-lg-4 mb10">
                            <div class="bloglist s2 item">
                                <div class="post-content">
                                    <div class="post-image">
                                        <div class="date-box">
                                            <div class="m">10</div>
                                            <div class="d">MAR</div>
                                        </div>
                                        <img alt="" src="images/news/pic-blog-1.jpg" class="lazy">
                                    </div>
                                    <div class="post-text">
                                        <h4><a href="news-single.html">Enjoy Best Travel Experience<span></span></a></h4>
                                        <p>Dolore officia sint incididunt non excepteur ea mollit commodo ut enim reprehenderit cupidatat labore ad laborum consectetur.</p>
                                        <a class="btn-main" href="#">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 mb10">
                            <div class="bloglist s2 item">
                                <div class="post-content">
                                    <div class="post-image">
                                        <div class="date-box">
                                            <div class="m">12</div>
                                            <div class="d">MAR</div>
                                        </div>
                                        <img alt="" src="images/news/pic-blog-2.jpg" class="lazy">
                                    </div>
                                    <div class="post-text">
                                        <h4><a href="news-single.html">The Future of Car Rent<span></span></a></h4>
                                        <p>Dolore officia sint incididunt non excepteur ea mollit commodo ut enim reprehenderit cupidatat labore ad laborum consectetur.</p>
                                        <a class="btn-main" href="#">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 mb10">
                            <div class="bloglist s2 item">
                                <div class="post-content">
                                    <div class="post-image">
                                        <div class="date-box">
                                            <div class="m">14</div>
                                            <div class="d">MAR</div>
                                        </div>
                                        <img alt="" src="images/news/pic-blog-3.jpg" class="lazy">
                                    </div>
                                    <div class="post-text">
                                        <h4><a href="news-single.html">Holiday Tips For Backpacker<span></span></a></h4>
                                        <p>Dolore officia sint incididunt non excepteur ea mollit commodo ut enim reprehenderit cupidatat labore ad laborum consectetur.</p>
                                        <a class="btn-main" href="#">Read More</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-testimonials" class="no-top no-bottom">
                <div class="container-fluid">
                    <div class="row g-0 align-items-center">

                        <div class="col-md-4">
                            <div class="de-image-text">
                                <div class="d-text">
                                    <div class="d-quote id-color"><i class="fa fa-quote-right"></i></div>
                                    <h4>Excellent Service! Car Rent Service!</h4>
                                    <blockquote>
                                       I have been using Rentaly for my Car Rental needs for over 5 years now. I have never had any problems with their service. Their customer support is always responsive and helpful. I would recommend Rentaly to anyone looking for a reliable Car Rental provider.
                                       <span class="by">Stepanie Hutchkiss</span>
                                   </blockquote>
                                </div>
                                <img src="images/testimonial/1.jpg" class="img-fluid" alt="">
                            </div>
                        </div>


                        <div class="col-md-4">
                            <div class="de-image-text">
                                <div class="d-text">
                                    <div class="d-quote id-color"><i class="fa fa-quote-right"></i></div>
                                    <h4>Excellent Service! Car Rent Service!</h4>
                                    <blockquote>
                                       We have been using Rentaly for our trips needs for several years now and have always been happy with their service. Their customer support is Excellent Service! and they are always available to help with any issues we have. Their prices are also very competitive.
                                       <span class="by">Jovan Reels</span>
                                   </blockquote>
                                </div>
                                <img src="images/testimonial/2.jpg" class="img-fluid" alt="">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="de-image-text">
                                <div class="d-text">
                                    <div class="d-quote id-color"><i class="fa fa-quote-right"></i></div>
                                    <h4>Excellent Service! Car Rent Service!</h4>
                                    <blockquote>
                                       Endorsed by industry experts, Rentaly is the Car Rental solution you can trust. With years of experience in the field, we provide fast, reliable and secure Car Rental services.
                                       <span class="by">Kanesha Keyton</span>
                                   </blockquote>
                                </div>
                                <img src="images/testimonial/3.jpg" class="img-fluid" alt="">
                            </div>
                        </div>

                    </div>
                </div>
            </section>

            <section id="section-faq">
                <div class="container">
                    <div class="row">
                        <div class="col text-center">
                            <h2>Have Any Questions?</h2>
                            <div class="spacer-20"></div>
                        </div>
                    </div>
                    <div class="row g-custom-x">
                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-1">
                                        How do I get started with Car Rental?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-1">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-2">
                                        What is difference for each plan?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-2">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-3">
                                        What kind of Car Rental do I need?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-3">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 wow fadeInUp">
                            <div class="accordion secondary">
                                <div class="accordion-section">
                                    <div class="accordion-section-title" data-tab="#accordion-b-4">
                                        Why do I need domain name?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-4">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-5">
                                        What my website protected from hackers?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-5">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                    <div class="accordion-section-title" data-tab="#accordion-b-6">
                                        How do I backup my website?
                                    </div>
                                    <div class="accordion-section-content" id="accordion-b-6">
                                        <p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section id="section-call-to-action" class="bg-color-2 pt60 pb60 text-light">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 offset-lg-1">
                            <h2 class="s2">Call us for further information. Rentaly customer care is here to help you anytime.</h2>
                        </div>

                        <div class="col-lg-5 text-lg-center text-sm-center">
                            <div class="phone-num-big">
                                <i class="fa fa-phone"></i>
                                <span class="pnb-text">
                                    Call Us Now
                                </span>
                                <span class="pnb-num">
                                    1 200 333 800
                                </span>
                            </div>
                            <a href="#" class="btn-main">Contact Us</a>
                        </div>
                    </div>
                </div>
            </section>

        </div>
        <!-- content close -->
        <a href="#" id="back-to-top"></a>
        <!-- footer begin -->
        <footer class="text-light">
            <div class="container">
                <div class="row g-custom-x">
                    <div class="col-lg-3">
                        <div class="widget">
                            <h5>{{ $ayar['siteadi'] }} Hakkında</h5>
                            <p>{{ $ayar['footerhakkinda'] }}</p>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="widget">
                            <h5>İletişim Bilgileri</h5>
                            <address class="s1">
                                <span style="font-size: 13px!important;"><i class="id-color fa fa-map-marker fa-lg"></i>{{ $ayar['adres'] }}</span>
                                <span><i class="id-color fa fa-phone fa-lg"></i>{{$ayar['telefon']}}</span>
                                <span><i class="id-color fa fa-envelope-o fa-lg"></i><a href="mailto:{{$ayar['mail']}}">{{$ayar['mail']}}</a></span>
                                <span><i class="id-color fa fa-file-pdf-o fa-lg"></i><a href="/basin-kiti">Basın Kiti</a></span>
                            </address>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <h5>Önemli Linkler</h5>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="widget">
                                    <ul>
                                        @foreach($linkler as $link)
                                        <li><a href="{{ $link->link }}">{{ $link->baslik }}</a></li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3">
                        <div class="widget">
                            <h5>Social Network</h5>
                            <div class="social-icons">
                                <a href="#"><i class="fa fa-facebook fa-lg"></i></a>
                                <a href="#"><i class="fa fa-twitter fa-lg"></i></a>
                                <a href="#"><i class="fa fa-linkedin fa-lg"></i></a>
                                <a href="#"><i class="fa fa-pinterest fa-lg"></i></a>
                                <a href="#"><i class="fa fa-rss fa-lg"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="subfooter">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="de-flex">
                                <div class="de-flex-col">
                                    <a href="/">
                                        Copyright {{ date('Y') }} - {{$ayar['siteadi']}}
                                    </a>
                                </div>
                                <ul class="menu-simple">
                                    <li><a href="#">Terms &amp; Conditions</a></li>
                                    <li><a href="#">Privacy Policy</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <!-- footer close -->
    </div>



    <!-- Javascript Files
    ================================================== -->
    <script src="js/plugins.js"></script>
    <script src="js/designesia.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDgiM7ogCAA2Y5pgSk2KXZfxF5S_1jsptA&libraries=places&callback=initPlaces" async="" defer=""></script>

</body>

<style>
    .saatsec { color: white!important;}
    .saatsec:focus { color: red!important;}
    @media only screen and (min-width: 768px) {
        section:first-of-type {
            padding-top: 120px!important;
        }
    }

    @media only screen and (max-width: 767px) {
        section:first-of-type {
            padding-top: 0px!important;
        }
    }

    .odeme { width: 100%; margin-bottom: 10px;}
</style>

</html>
