@extends('master')
@section('icerik')

    <div class="container mt-4">

        <h3>Banka Hesap Numaralarımız</h3>

        @if($request->tur=="kiralama")
            <p>Lütfen açıklama kısmına <b>K{{ $tn->kid }}</b> ve İsminizi Yazın.</p>
        @else
        <p>Lütfen açıklama kısmına <b>T{{ $request->sorgu }}</b> ve İsminizi Yazın.</p>
        @endif

        <div class="row">

            @foreach($hesapno as $item)
            <div class="col-xl-4 col-lg-4" style="background-size: 100%; background-repeat: no-repeat;">
                <div class="de-item mb30" style="background-size: 100%; background-repeat: no-repeat;">
                    <div class="d-img" style="background-size: 100%; background-repeat: no-repeat;">
                    </div>
                    <div class="d-info" style="background-size: 100%; background-repeat: no-repeat;">
                        <div class="d-text" style="background-size: 100%; background-repeat: no-repeat;">
                            <h4>{{ $item->bankaadi }}</h4>
                            <div class="d-item_like" style="background-size: 100%; background-repeat: no-repeat;">

                            </div>
                            <div class="d-atr-group" style="background-size: 100%; background-repeat: no-repeat;">
                               {{ $item->hesapsahibi }}
                                <br> <b>{{ $item->iban }}</b>
                            </div>

                            @if($kira>0)
                                <div class="hn">


                                    <div>

                                        <div>
                                            Kapora Ücreti <span>{{ $ayar['kapora'] }}</span>
                                        </div>
                                        <a href="/odemebildir?kid={{ $tn->kid }}&tur=kapora&banka={{ $item->id }}" class="btn-main mt-3"> Kapora Ödeme Bildir</a>

                                    </div>
                                    <div>
                                        <div>
                                            Tüm Ücret <span>{{ number_format($kira,0) }} {{ $ayar['pb'] }}</span>
                                        </div>
                                        <a href="/odemebildir?kid={{ $tn->kid }}&tur=full&banka={{ $item->id }}" class="btn-main mt-3">Tüm Ödeme Bildir</a>

                                    </div>
                                </div>
                            @else
                            <div class="hn">


                                <div>

                                <div>
                                Tek Yön <span>{{ $request->tek }} {{ $ayar['pb'] }}</span>
                                </div>
                                <a href="/odemebildir?sorgu={{ $request->sorgu }}&banka={{ $item->id }}&yon=Tek" class="btn-main mt-3"> Tek Yön Ödeme Bildir</a>

                            </div>
                            <div>
                                <div>
                                Çift Yön <span>{{ $request->cift }} {{ $ayar['pb'] }}</span>
                                </div>
                                <a href="/odemebildir?sorgu={{ $request->sorgu }}&banka={{ $item->id }}&yon=Çift" class="btn-main mt-3">Çift Yön Ödeme Bildir</a>

                            </div>
                            </div>
                            @endif
                            <div class="clearfix"></div>


                        </div>
                    </div>
                </div>
            </div>
            @endforeach

        </div>

    </div>

    <style>
        .hn { display: flex}
        .hn div {
            float: left;
            margin-right: 10px;
            margin-top: 10px;

        }
        .hn div div { font-weight: bolder; font-size: 10px; text-align: center;}
        .hn div div span { font-weight: bolder; font-size: 20px;}
    </style>


@endsection
