@php use Illuminate\Support\Carbon; @endphp
@extends('master')
@section('icerik')

    <section id="section-hero" aria-label="section" class=" mt-80 sm-mt-0"
             style="background-size: 100%; background-repeat: no-repeat;">

        <div class="container" style="background-size: 100%; background-repeat: no-repeat;">

            <div class="row align-items-center pt-3" style="background-size: 100%; background-repeat: no-repeat;">
                <h3>Rezervasyon Onayla</h3>
                <div class="col-lg-12" style="background-size: 100%; background-repeat: no-repeat;">

                    <div class="p-4 rounded-5 shadow-2-strong bgcustom" data-bgcolor="#ffffff"
                         style="background-color: rgb(255, 255, 255); background-size: 100%; background-repeat: no-repeat;">


                        <form name="contactForm" id="contact_form" method="post"
                              action="/paytr?sorgu={{ $request->sorgu }}&tip=transfer">
                            <input type="hidden" name="arac" value="{{$request->arac}}">
                            @csrf
                            <div id="step-1" class="row" style="background-size: 100%; background-repeat: no-repeat;">
                                <div class="col-lg-5 mb30" style="background-size: 100%; background-repeat: no-repeat;">
                                    <h5><i class="fa fa-arrow-circle-o-up"></i> Transfer Şeklini Seçiniz</h5>

                                    <div class="de_form de_radio row g-3"
                                         style="background-size: 100%; background-repeat: no-repeat;">
                                        <div class="radio-img col-lg-6 col-sm-3 col-6"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <input id="radio-1a" name="miktar" type="radio"
                                                   value="Tek|{{ (($transfer->distance*$arac->km)+$arac->acilis) }}"
                                                   checked="checked" class="secimx">
                                            <label for="radio-1a">
                                                <img src="/images/tekyon.png"
                                                     style="height: 64px; width: auto!important;" alt="">
                                                Tek Yön
                                                <br>
                                                @if(session()->get('pb')==$ayar['pb'])
                                                    <span>{{ number_format(($miktar),2) }}  {{ $ayar['pb'] }}</span>
                                                @else
                                                    <span>{{ number_format((($transfer->distance * $arac->km) + $arac->acilis) * $doviz[$ayar['pb']] / $doviz[session()->get('pb')], 2) }}
                                                        {{ session()->get('pb') }}</span>
                                                @endif
                                            </label>

                                        </div>

                                        <div class="radio-img col-lg-6 col-sm-3 col-6"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <input id="radio-1b" name="miktar" type="radio"
                                                   value="Çift|{{ ($arac->acilis+(($arac->acilis)+($transfer->distance*$arac->km*1.75)))}}"
                                                   class="secimx">
                                            <label for="radio-1b">
                                                <img src="/images/ciftyon.png" alt=""
                                                     style="height: 64px; width: auto!important;">
                                                Çift Yön
                                                <br>


                                                @if(session()->get('pb')==$ayar['pb'])
                                                    <span>{{ number_format(($miktar*1.75),2) }}  {{ $ayar['pb'] }}</span>
                                                @else
                                                    <span>{{ number_format((($transfer->distance * $arac->km) + $arac->acilis) * $doviz[$ayar['pb']] / $doviz[session()->get('pb')]*1.75, 2) }}
                                                        {{ session()->get('pb') }}</span>
                                                @endif


                                            </label>
                                        </div>


                                    </div>
                                </div>

                                <div class="col-lg-7" style="background-size: 100%; background-repeat: no-repeat;">
                                    <div class="row" style="background-size: 100%; background-repeat: no-repeat;">
                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-map-marker"></i> Alınma Noktası</h5>
                                            <input type="text" name="alinmanoktasi"
                                                   placeholder="Enter your pickup location" readonly
                                                   value="{{ $transfer->alinmanoktasi }}" id="autocomplete"
                                                   autocomplete="off" class="form-control pac-target-input">

                                            <div class="jls-address-preview jls-address-preview--hidden"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <div class="jls-address-preview__header"
                                                     style="background-size: 100%; background-repeat: no-repeat;">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-map-marker"></i> Bırakılma Noktası</h5>
                                            <input type="text" name="birakilmanoktasi"
                                                   value="{{$transfer->birakilmanoktasi}}" readonly
                                                   placeholder="Enter your dropoff location" id="autocomplete2"
                                                   autocomplete="off" class="form-control pac-target-input">

                                            <div class="jls-address-preview jls-address-preview--hidden"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <div class="jls-address-preview__header"
                                                     style="background-size: 100%; background-repeat: no-repeat;">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-calendar-check-o"></i> Alınma Tarihi</h5>
                                            <div class="date-time-field"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <input type="text" id="date-picker" name="alinmatarihvesaati"
                                                       style="width: 100%" class="form-control" readonly
                                                       value="{{ Carbon::createFromDate($transfer->alinmatarihi)->format('d/m/Y H:i') }}">

                                            </div>
                                        </div>

                                        <div class="col-lg-6 mb20"
                                             style="background-size: 100%; background-repeat: no-repeat;">
                                            <h5><i class="fa fa-calendar-check-o"></i> Bırakılma tarih ve saati</h5>
                                            <div class="date-time-field"
                                                 style="background-size: 100%; background-repeat: no-repeat;">
                                                <input type="text" id="date-picker-2" name="birakilmatarihi"
                                                       value="{{ Carbon::createFromDate($transfer->alinmatarihi)->format('d/m/Y H:i') }}"
                                                       class="form-control" style="width: 100%" readonly>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12">

                                    <h4>Satın alabileceğiniz ek hizmetler</h4>
                                    <style>
                                        .ekhizmet li input {
                                            margin-left: 20px;
                                        }
                                    </style>

                                    <ul style="list-style: none" class="ekhizmet">
                                        @foreach($ekhizmet as $item)

                                            @if(session()->get('pb')==$ayar['pb'])
                                                <li class="mb-2">
                                                    <label for="v{{ $item->id }}"><input type="checkbox"
                                                                                         style="appearance: auto!important;"
                                                                                         id="v{{ $item->id  }}"
                                                                                         name="ekhizmet[]"
                                                                                         value="{{ $item->id }}"> {{ $item->hizmet }}
                                                        <b>{{ $item->ucret }} {{ $ayar['pb'] }}</b>
                                                    </label>

                                                </li>
                                            @else

                                                <li class="mb-2">
                                                    <label for="v{{ $item->id }}"><input type="checkbox"
                                                                                         style="appearance: auto!important;"
                                                                                         id="v{{ $item->id  }}"
                                                                                         name="ekhizmet[]"
                                                                                         value="{{ $item->id }}"> {{ $item->hizmet }}
                                                        <b>{{ number_format($item->ucret * $doviz[$ayar['pb']] / $doviz[session()->get('pb')], 2) }}
                                                            {{ session()->get('pb') }}</b>
                                                    </label>
                                                </li>

                                            @endif

                                        @endforeach
                                    </ul>

                                </div>


                                <div class="col-lg-3"></div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <button class="btn-main odeme pull-right"><i class="fa fa-credit-card-alt"></i>
                                        Kredi Kartı İle Ödeme Yap
                                    </button>
                                </div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <a href="/havale?tur=transfer&arac={{ $request->arac }}&sorgu={{$request->sorgu}}"
                                       class="btn-main pull-right odeme"><i class="fa fa-calendar-check-o"></i> Banka
                                        Transferi ile Ödeme Yap</a>
                                </div>
                                <div class="col-lg-3" style="background-size: 100%; background-repeat: no-repeat;">
                                    <a href="/sofor?arac={{ $request->arac }}&sorgu={{ $request->sorgu }}"
                                       class="btn-main pull-right odeme"><i class="fa fa-car"></i> Transferde Şöfore öde
                                        (+10%)</a>
                                </div>

                            </div>

                        </form>
                    </div>
                </div>
            </div>

            <div class="spacer-single" style="background-size: 100%; background-repeat: no-repeat;"></div>


        </div>
    </section>

    <style>

    </style>


    {{--    --}}
    {{--<div>--}}
    {{--    <div class="container">--}}
    {{--       <div class="mt-3 mb-3">--}}
    {{--           <h3>Rezervasyon Tamamlama</h3>--}}

    {{--           @if(!auth()->check())--}}
    {{--               <div class="alert-warning alert"><i class="fa fa-warning"></i> Şu an üye girişi yapmadan devam ediyorsunuz. üyeliğiniz var ise--}}
    {{--                   <a href="/login">lütfen giriş yapın</a>. <br> Giriş yapmadığınız takdirde e-posta adresiniz ile otomatik üyelik tanımlanıp bilgileri tarafınıza iletilecektir.</div>--}}

    {{--           @endif--}}

    {{--           <div class="fs-10">--}}
    {{--          Tercih ettiğiniz <b> {{ $arac->isim }}</b> ile, transferinize devam etmek için tek yön ya da çift yön seçeneklerimizden birini seçip, bilgilerinizi doldurmanız gerekmektedir.Eğer giriş yaparsanız kayıtlı bilgileriniz ile formunuz doldurularak devam edebileceksiniz.--}}
    {{--       </div>--}}
    {{--       </div>--}}
    {{--    </div>--}}
    {{--</div>--}}
@endsection
