<?php $__env->startSection('icerik'); ?>

    <div class="pagetitle">
        <h1>Tur Düzenle</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/">Site</a></li>
                <li class="breadcrumb-item active">Tur Düzenle</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->


    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header"><i class="bx bx-plus-circle"></i> Tur Duzenle</div>
                    <div class="card-body">

                        <form action="turduzenle" class="arala" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($request->id); ?>">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="baslik">Tur Adı</label>
                                        <input required type="text" value="<?php echo e($tur->baslik); ?>" class="form-control" name="baslik">
                                    </div>

                                    <div class="form-group">
                                        <label for="katid">Tur Kategorisi</label>
                                        <select name="katid" class="form-select">
                                            <option>Kategori Seçiniz</option>
                                            <?php $__currentLoopData = $kat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if($tur->katid==$item->id): ?> selected <?php endif; ?> value="<?php echo e($item->id); ?>"><?php echo e($item->turkat); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="star">Öne Çıkan Özellik</label>
                                        <input required type="text" class="form-control" name="star" value="<?php echo e($tur->star); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="baslama">Başlama Saati</label>
                                        <input required type="text" class="form-control" name="baslama" value="<?php echo e($tur->baslama); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="bitis">Bitiş Saati</label>
                                        <input required type="text" class="form-control" name="bitis" value="<?php echo e($tur->bitis); ?>">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="yetiskin">Yetişkin Fiyat</label>
                                        <input required type="text" class="form-control" name="yetiskin" value="<?php echo e($tur->yetiskin); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="bcocuk">Büyük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="bcocuk" value="<?php echo e($tur->bcocuk); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="kcocuk">Küçük Çocuk Fiyat</label>
                                        <input required type="text" class="form-control" name="kcocuk" value="<?php echo e($tur->kcocuk); ?>">
                                    </div>

                                    <div class="form-group">
                                        <label for="bebek">Bebek Fiyat</label>
                                        <input required type="text" class="form-control" name="bebek" value="<?php echo e($tur->bebek); ?>">
                                    </div>

                                    <div class="form-group ">
                                        <label for="img">Kapak Fotoğrafı</label>
                                        <div class="input-group">


                                        <input  type="file" value="<?php echo e($tur->img); ?>" accept="image/*" name="img" class="form-control">
                                            <input type="hidden" name="eskimg" value="<?php echo e($tur->img); ?>">
                                       <div style="vertical-align: middle; line-height: 40px; margin-left: 20px">*Yeni fotoğraf yüklemezseniz eskisi kalır.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                Tur Kısa Tanım
                                <textarea name="turkisatanim" class="form-control" id="" cols="30" rows="5" placeholder="2 paragraf tur kısa tanım"><?php echo $tur->turkisatanim; ?></textarea>
                            </div>
                            <div class="form-group">
                                <label for="program">Tur Tanıtımı</label>
                                <div class="editor-container">
                                    <textarea id="editor" name="program"><?php echo $tur->program; ?></textarea>
                                </div>
                                <script>
                                    ClassicEditor
                                        .create(document.getElementById('editor'))
                                        .then(editor => {
                                            console.log('Editor was initialized');
                                        })
                                        .catch(error => {
                                            console.error(error);
                                        });
                                </script>
                            </div>

                            <button class="btn btn-success"><i class="bx bxs-save"></i> Kaydet</button>
                        </form>


                    </div>
                </div>
            </div>

        </div>
    </section>

    <style>
        .arala * {
            margin-bottom: 5px;
            margin-top: 5px;
            clear: both
        }

        .arabafoto { border-radius: 5px; border: solid 0.5px darkgray; padding: 3px}
    </style>
    <style>
        /* Set the height of the textarea to 30% of the viewport height */
        #editor {
            height: 30vh;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title','Tur Düzenle'); ?>

<?php echo $__env->make('panel.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\transferpro2\resources\views/admin/turduzenle.blade.php ENDPATH**/ ?>